/**************************************************************

	Script		: Overlay
	Version		: 1.2
	Authors		: Samuel birch
	Desc		: Covers the window with a semi-transparent layer.
	Licence		: Open Source MIT Licence
	Modified	: Liam Smart (liam_smart@hotmail.com) - MooTools 1.2 support

**************************************************************/

//start overlay class
var Overlay = new Class({
	
	getOptions: function(){
		return {
			colour: '#000',
			opacity: 0.7,
			zIndex: 1,
			container: $(document.body),
			onClick: new Class()
		};
	},

	initialize:function(options)
	{
		this.setOptions(this.getOptions(),options);
		
		this.container = new Element('div').setProperty('id','OverlayContainer').setStyles({
			position: 'absolute',
			left: '0px',
			top: '0px',
			width: '100%',
			visibility: 'hidden',
			overflow: 'hidden',
			zIndex: this.options.zIndex
		}).inject(this.options.container,'inside');
		
		this.iframe = new Element('iframe').setProperties({
			id: 'OverlayIframe',
			name: 'OverlayIframe',
			src: 'javascript:void(0);',
			frameborder: 0,
			scrolling: 'no'
		}).setStyles({
			position: 'absolute',
			top: 0,
			left: 0,
			width: '100%',
			height: '100%',
			filter: 'progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)',
			opacity: 0,
			zIndex: 1
		}).inject(this.container,'inside');
		
		this.overlay = new Element('div').setProperty('id','Overlay').setStyles({
			position: 'absolute',
			left: '0px',
			top: '0px',
			width: '100%',
			height: '100%',
			zIndex: 2,
			backgroundColor: this.options.colour
		}).inject(this.container,'inside');
		
		this.container.addEvent('click',function(){
			this.options.onClick();
		}.bind(this));
		
		this.fade = new Fx.Morph(this.container);
		this.position();
		
		window.addEvent('resize',this.position.bind(this));
	},
	
	position: function(){
		this.container.setStyle('height','0');//reset container height ready for resize( removes scrollbar so new calc is true - liam)
		if(this.options.container == document.body){
			if(this.options.container.getSize().y >= this.options.container.getScrollSize().y){
				this.container.setStyles({
					width: window.getSize().x+'px',
					height: window.getSize().y+'px'
				});
			}else{
				this.container.setStyles({
					width: window.getSize().x+'px',
					height: window.getScrollSize().y+'px'
				});
			}
		}else{ 
			var myCoords = this.options.container.getCoordinates(); 
			this.container.setStyles({
				top: myCoords.top+'px',
				height: myCoords.height+'px',
				left: myCoords.left+'px',
				width: myCoords.width+'px'
			});
		};
	},
	
	show: function(){
		this.fade.start({
			opacity: this.options.opacity,
			visibility: 'visible'
		});
	},
	
	hide: function(){
		this.fade.start({
			opacity: 0,
			visibility: 'hidden'
		});
	}
});

Overlay.implement(new Options);